%To calculate SS replenishment from river bed after trapping by dams
function [Sum_tr, Sum_SS, Sum_depBD, Sum_SS_depBD] = DAMSED(ReachData_SS, ReachData_BD, Network_SS, Network_BD, damdata, extdata_SS, extdata_BD, Q_scenario, scenario_frequency, Fi_r_SS, Fi_r_BD)
%% 
%INPUT：
%
%ReachData_SS   =  based on SS grain size distribution
%ReachData_BD   =  based on bed load grain size distribution
%Network_SS     =  graph_preprocessing(ReachData_SS)
%Network_BD     =  graph_preprocessing(ReachData_BD)
%damdata        =  dam data info with reach ID
%extdata_SS     =  SS inflow to the river network
%extdata_BD     =  Available bed load to supplement SS



%OUTPUT: 
%
%Sum_tr     =   SS with replenishment from river bed
%Sum_SS     =   SS with no replenishment from river bed
%Sum_depBD  =   Deposition on each reach
%Sum_SS_depBD  =  Amount of bedload to SS
    
    %When no dam exists
    [Qbi_tr1 , Qbi_dep1, QB_tr1, QB_dep1, Fi_r_SS] = SS_transport( ReachData_SS ,  Network_SS,'external_sed_flow', extdata_SS , 'tr_cap_equation', 3, 'hydr_estimation',1 , 'Fi_r', Fi_r_SS);
    QB_tr_ND = QB_tr1.*60.*60.*24.*365;
    Sum_tr_ND = (sum(QB_tr_ND)./1000./10000)';
 
    %Introducing dam
    [Qbi_tr_SStemp , Qbi_dep_SStemp, QB_tr_SStemp, QB_dep_SStemp, Fi_r_SS] = SS_transport( ReachData_SS ,  Network_SS,'external_sed_flow', extdata_SS , 'dams', damdata, 'tr_cap_equation', 3, 'hydr_estimation',1 , 'Fi_r', Fi_r_SS);
    QB_tr_SS = QB_tr_SStemp.*60.*60.*24.*365;
    QB_dep_SS = QB_dep_SStemp.*60.*60.*24.*365;
    Sum_SS = (sum(QB_tr_SS)./1000./10000)';
    
    
    p = [0 cumsum(scenario_frequency) ];
    p_year = p.*365; 
    p_class_length = diff(p_year); %number of days for each class

    QB_tr_BD = zeros(size(ReachData_BD,1),size(ReachData_BD,1));
    QB_dep_BD = zeros(size(ReachData_BD,1),size(ReachData_BD,1));

    % loop for each scenario 
    for i=1:(length(p)-1)
    
        q = num2cell(Q_scenario(:,i+1));
        [ReachData_BD.Q] = q{:}; %attribute value of flow according to the percentile previously calculated

        %run DAMSED for the scenario, and save the results into temporary
        %matrices with the results for each percentile ("perc")
        [Qbi_tr_per , Qbi_dep_per, QB_tr_per, QB_dep_per , Fi_r_BD ] = SS_transport( ReachData_BD ,  Network_BD ,  'dams', damdata, 'tr_cap_equation', 1, 'partition_formula', 4, 'hydr_estimation',1,'dams', damdata, 'Fi_r', Fi_r_BD);
    
        % aggregate results according the the frequency of the scenario
        QB_tr_BD = QB_tr_BD + (QB_tr_per.*60.*60.*24.*p_class_length(i));
        QB_dep_BD = QB_dep_BD + (QB_dep_per.*60.*60.*24.*p_class_length(i));
    
    end
    %%Sum up the SS for the whole year
    Sum_trBD = (sum(QB_tr_BD)./1000./10000)';
    Sum_depBD = (sum(QB_dep_BD)./1000./10000)';
    
   
    Dep_Damtemp = (sum(QB_dep_BD)./60./60./24./365)'.* 0.1745;

    %SS replenishment starts from the reach downstream to dams
    Dep_Dam = (Sum_SS < Sum_tr_ND).* Dep_Damtemp + (~(Sum_SS < Sum_tr_ND)).* zeros(length(Dep_Damtemp),1);

    %No SS replenishment on the reach where dam locate
    Dam_id = [damdata.node_id];
    Reach_id = [ReachData_SS.reach_id]';
    [is, index_Dam] = ismember(Dam_id, Reach_id);
    Dep_Dam(index_Dam) = 0;
    SS_fromDam = num2cell(Dep_Dam);
    
   
    [extdata_BD.sed_flow] = SS_fromDam{:};
    
    [Qbi_tr4 , Qbi_dep4, QB_tr4, QB_dep4 , Fi_r_SS] = SS_transport(ReachData_SS ,  Network_SS ,'external_sed_flow', extdata_BD , 'tr_cap_equation', 3, 'hydr_estimation',1 , 'Fi_r', Fi_r_SS);
    QB_tr_depBD = QB_tr4.*60.*60.*24.*365;
    Sum_SS_depBD = (sum(QB_tr_depBD)./1000./10000)';
    
    Sum_SStemp = (~(Sum_SS < Sum_tr_ND)).* Sum_SS + (Sum_SS < Sum_tr_ND).* (Sum_SS + Sum_trBD + Sum_SS_depBD);

    
    Sum_SStemp(index_Dam) = Sum_SS(index_Dam);

    Sum_tr = (Sum_SStemp < Sum_tr_ND).* Sum_SStemp + (~(Sum_SStemp < Sum_tr_ND)).* Sum_tr_ND;
end

    


